<?php

function myc_retrieve_doc_attachment($all_ids, $returnfile, $user) {
	global $log,$adb;
	$entities=array();
	$docWSId=myc_getWSEntityId('Documents');
	$log->debug("Entering function vtws_retrievedocattachment");
     
        $all_ids="(".str_replace($docWSId,'',$all_ids).")";
        $query = "SELECT n.notesid, n.filename, n.filelocationtype
                  FROM vtiger_notes n
                  INNER JOIN vtiger_crmentity c ON c.crmid=n.notesid
                  WHERE n.notesid in $all_ids and n.filelocationtype in ('I','E') and c.deleted=0";
          
	$result = $adb->query($query);
	$nr=$adb->num_rows($result);
	
	
    for($i=0;$i<$nr;$i++){  	
        $id=$docWSId.$adb->query_result($result,$i,'notesid');
        
        $webserviceObject = VtigerWebserviceObject::fromId($adb,$id);
       
	$handlerPath = $webserviceObject->getHandlerPath();
	$handlerClass = $webserviceObject->getHandlerClass();
	
	require_once $handlerPath;
	$handler = new $handlerClass($webserviceObject,$user,$adb,$log);
	$meta = $handler->getMeta();
	$entityName = $meta->getObjectEntityName($id);
	
	$types = vtws_listtypes(null, $user);
	
	if(!in_array($entityName,$types['types'])){
		throw new WebServiceException(WebServiceErrorCode::$ACCESSDENIED,"Permission to perform the operation is denied");
	}
	if($meta->hasReadAccess()!==true){
		throw new WebServiceException(WebServiceErrorCode::$ACCESSDENIED,"Permission to write is denied");
	}
	if($entityName !== $webserviceObject->getEntityName()){
		throw new WebServiceException(WebServiceErrorCode::$INVALIDID,"Id specified is incorrect");
	}
	
	if(!$meta->hasPermission(EntityMeta::$RETRIEVE,$id)){
		throw new WebServiceException(WebServiceErrorCode::$ACCESSDENIED,"Permission to read given object ($id) is denied");
	}
	
	$ids = vtws_getIdComponents($id);
	if(!$meta->exists($ids[1])){
		throw new WebServiceException(WebServiceErrorCode::$RECORDNOTFOUND,"Document Record you are trying to access is not found");
	}
	$document_id = $ids[1];
	$filetype=$adb->query_result($result,$i,'filelocationtype');
	if ($filetype=='E'){
		$entity["recordid"] = $adb->query_result($result,$i,'notesid');
		$entity["filetype"] = $fileType;
		$entity["filename"] = $adb->query_result($result,$i,'filename');
		$entity["filesize"] = 0;
		$entity["attachment"] = base64_encode('') ;
	} elseif ($filetype=='I') {
		$entity = myc_retrievedocattachment_get_attachment($document_id,true,$returnfile);
	}        
	$entities[$id]=$entity;
	VTWS_PreserveGlobal::flush();
    } // end for ids
	$log->debug("Leaving function vtws_retrievedocattachment");
	return $entities;
}
function myc_retrievedocattachment_get_attachment($fileid,$nr=false,$returnfile=true) {
	global $adb, $log, $default_charset;
	$log->debug("Entering function vtws_retrievedocattachment_get_attachment($fileid)");
	
	$recordpdf=array();
	$query = 'SELECT vtiger_attachments.attachmentsid,path,filename,filesize,filetype,name FROM vtiger_attachments
	INNER JOIN vtiger_seattachmentsrel ON vtiger_seattachmentsrel.attachmentsid = vtiger_attachments.attachmentsid
	INNER JOIN vtiger_notes ON vtiger_notes.notesid = vtiger_seattachmentsrel.crmid
	WHERE vtiger_notes.notesid = ?';
	$result = $adb->pquery($query,array($fileid));
	if ($adb->num_rows($result)==0 && $nr==false)
	  throw new WebServiceException(WebServiceErrorCode::$RECORDNOTFOUND,"Attachment Record you are trying to access is not found ($fileid)");
	if($adb->num_rows($result) == 1)
	{
		$fileType = @$adb->query_result($result, 0, "filetype");
		$name = @$adb->query_result($result, 0, "filename");
		$name = html_entity_decode($name, ENT_QUOTES, $default_charset);
		$filepath = $adb->query_result($result,0,'path');
		$attachid = $adb->query_result($result,0,'attachmentsid');
		$saved_filename = $attachid."_".$name;
		if(!file_exists($filepath.$saved_filename))
		$saved_filename = $attachid."_".@html_entity_decode($adb->query_result($result, 0, "name"), ENT_QUOTES, $default_charset);
		$filesize = filesize($filepath.$saved_filename);
		if(!fopen($filepath.$saved_filename, "r"))
		{
			$log->debug('Unable to open file');
			return array();
			throw new WebServiceException(WebServiceErrorCode::$ACCESSDENIED,"Unable to open file $saved_filename. Object is denied");
		}
		else
		{
			$fileContent = $returnfile ? fread(fopen($filepath.$saved_filename, "r"), $filesize) : '';
		}
		if($fileContent != '')
		{
			$log->debug('About to update download count');
			$sql = "select filedownloadcount from vtiger_notes where notesid= ?";
			$download_count = $adb->query_result($adb->pquery($sql,array($fileid)),0,'filedownloadcount') + 1;
			$sql="update vtiger_notes set filedownloadcount= ? where notesid= ?";
			$res=$adb->pquery($sql,array($download_count,$fileid));
		}
		$recordpdf["recordid"] = $fileid;
		$recordpdf["filetype"] = $fileType;
		$recordpdf["filename"] = $name;
		$recordpdf["filesize"] = $filesize;
		$recordpdf["attachment"] = base64_encode($fileContent);
	}
	
	$log->debug("Leaving function vtws_retrievedocattachment_get_attachment($fileid)");
    return $recordpdf;
}

function myc_getWSEntityId($entityName) {
		global $adb;
		$rs = $adb->query("select * from vtiger_ws_entity where name='$entityName'");
		$wsid = $adb->query_result_rowdata($rs, 0); 
		return $wsid['id']."x";
}







function myc_query_related($query, $id, $relatedLabel, $user, $filterClause = null) {
    global $log, $adb;

    $webserviceObject = VtigerWebserviceObject::fromId($adb, $id);
    $handlerPath  = $webserviceObject->getHandlerPath();
    $handlerClass = $webserviceObject->getHandlerClass();
    require_once $handlerPath;
    $handler = new $handlerClass($webserviceObject, $user, $adb, $log);
    $meta = $handler->getMeta();
    $entityName = $meta->getObjectEntityName($id);

	// Extract related module name from query.
    $relatedType = null;
    if (preg_match("/FROM\s+([^\s]+)/i", $query, $m)) {
	    $relatedType = trim($m[1]);
    }
    
    // Check for presence of expected relation.
    $found = false;
    $relatedTypes = myc_relatedtypes($entityName, $user);
    foreach ($relatedTypes['information'] as $label => $information) {
        if ($label == $relatedLabel && $information['name'] == $relatedType) {
            $found = true;
            break;
        }
    }

    if (!$found) {
        throw new WebServiceException(WebServiceErrorCode::$UNKOWNENTITY, "Relation specified is incorrect");
    }
    
    vtws_preserveGlobal('currentModule', $entityName);

	// Fetch related record IDs - so we can further retrieve complete information using vtws_query 
    $relatedWebserviceObject = VtigerWebserviceObject::fromName($adb, $relatedType);
    $relatedHandlerPath  = $relatedWebserviceObject->getHandlerPath();
    $relatedHandlerClass = $relatedWebserviceObject->getHandlerClass();
    require_once $relatedHandlerPath;
    $relatedHandler = new $relatedHandlerClass($relatedWebserviceObject, $user, $adb, $log);
    $relatedIds = $handler->relatedIds($id, $relatedType, $relatedLabel, $relatedHandler);

	// Initialize return value
	$relatedRecords = array();
	
	// Rewrite query and extract related records if there at least one.
    if (!empty($relatedIds)) {    	
        $relatedIdClause = "id IN ('".implode("','", $relatedIds)."')";
        if (stripos($query, 'WHERE') == false) {
            $query .= " WHERE " . $relatedIdClause;
        } else {
            $queryParts = explode('WHERE', $query);
            $query = $queryParts[0] ." WHERE " . $relatedIdClause;
            $query .= " AND " .$queryParts[1];
        }
        if(!empty($filterClause)){
            $query .= " " . $filterClause;
        }
        $query.=";";
        $relatedRecords = vtws_query($query, $user);
    }

	VTWS_PreserveGlobal::flush();	
    return $relatedRecords;
}


function myc_relatedtypes($elementType, $user) {
    global $adb, $log;

    $allowedTypes = vtws_listtypes(null, $user);

    $webserviceObject = VtigerWebserviceObject::fromName($adb, $elementType);
    $handlerPath  = $webserviceObject->getHandlerPath();
    $handlerClass = $webserviceObject->getHandlerClass();

    require_once $handlerPath;
    $handler = new $handlerClass($webserviceObject, $user, $adb, $log);
    $meta = $handler->getMeta();
    $tabid = $meta->getTabId();

    $sql = "SELECT vtiger_relatedlists.label, vtiger_tab.name, vtiger_tab.isentitytype FROM vtiger_relatedlists 
            INNER JOIN vtiger_tab ON vtiger_tab.tabid=vtiger_relatedlists.related_tabid 
            WHERE vtiger_relatedlists.tabid=? AND vtiger_tab.presence = 0";

    $params = array($tabid);
    $rs = $adb->pquery($sql, $params);

    $return = array('types' => array(), 'information' => array());

    while ($row = $adb->fetch_array($rs)) {
        if (in_array($row['name'], $allowedTypes['types'])) {
            $return['types'][] = $row['name'];
            // There can be same module related under different label - so label is our key.
            $return['information'][$row['label']] = array(
                'name' => $row['name'],
                'label'=> $row['label'],
                'isEntity' => $row['isentitytype']
            );
        }
    }

	return $return;
}

function mycv_retrieve_related($id, $relatedType, $relatedLabel, $user) {
    $query = 'SELECT * FROM ' . $relatedType;
    return myc_query_related($query, $id, $relatedLabel, $user);
}




?>