<?php
/*************************************************************************************************
 * Copyright 2012-2014 JPL TSolucio, S.L.  --  This file is a part of coreBOSCP.
* You can copy, adapt and distribute the work under the "Attribution-NonCommercial-ShareAlike"
* Vizsage Public License (the "License"). You may not use this file except in compliance with the
* License. Roughly speaking, non-commercial users may share and modify this code, but must give credit
* and share improvements. However, for proper details please read the full License, available at
* http://vizsage.com/license/Vizsage-License-BY-NC-SA.html and the handy reference for understanding
* the full license at http://vizsage.com/license/Vizsage-Deed-BY-NC-SA.html. Unless required by
* applicable law or agreed to in writing, any software distributed under the License is distributed
* on an  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and limitations under the
* License terms of Creative Commons Attribution-NonCommercial-ShareAlike 3.0 (the License).
*************************************************************************************************/


	function myc_retrieve_translations($language, $module="", $user) {

		if($module!="" && file_exists("languages/".$language."/".$module.".php")){
			require_once("languages/".$language."/".$module.".php");
			return $languageStrings;
		}
		elseif(file_exists("languages/".$language."/Vtiger.php")){
			require_once("languages/".$language."/Vtiger.php");
			return $languageStrings;
		}
		else{
			require_once("languages/en_us/Vtiger.php");
			return $languageStrings;
		}	
	}
	
	function myc_retrieve_languages_list($dummy, $user) {
	   global $adb;
	   $adb = PearDatabase::getInstance();

	   $language_query = 'SELECT prefix, label FROM vtiger_language';
	   $result = $adb->pquery($language_query, array());
	   $num_rows = $adb->num_rows($result);
	   for($i = 0; $i<$num_rows; $i++) {
		   $lang_prefix = decode_html($adb->query_result($result, $i, 'prefix'));
		   $label = decode_html($adb->query_result($result, $i, 'label'));
		   $languages_list[$lang_prefix] = $label;
	   }
	   return $languages_list;
	}
?>